/*
 * ListCollection.h
 *
 * Created 9/2/2009 By Johnny Huynh
 *
 * Version 00.00.01 9/2/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 // CURRENTLY, THIS IS NOT USED.
 
 #ifndef LIST_COLLECTION_H
 #define LIST_COLLECTION_H
 
 template <typename T> class ListCollection;
 
 #include <list>
 
 /**
  * Class specification for ListCollection
  */
 template <typename T>
 class ListCollection : private std::list<T>
 {
 // Public Encapsulated Classes
 public:
    class iterator;
 
 // Data Members
 protected:
 typedef std::list<T> std_list;
    
 // Local Functions
 public:
    ListCollection();
    ListCollection( const List<T>& list_collection );
    virtual ~ListCollection();
    inline ListCollection<T>& operator=( const ListCollection<T>& list_collection );
    inline void add( const T& value );
    inline typename ListCollection<T>::iterator begin();
    inline typename ListCollection<T>::iterator end();
    inline void clear();
    inline T get_front() const;
    inline void remove_front();
    inline size_t size() const;
 
 // Private Functions
 private:
    
 // Public Static Functions
 public:
 
 // Public Encapsulated Classes
 public:
    /**
     *  Class specification for ListCollection<T>::iterator
     */
    virtual class iterator
    {
    friend class ListCollection<T>; // for invoking private functions
    
    // Data members
    private:
        typename std_list::iterator _value_Itr;
    
    // Local Functions
    public:
        iterator() { }
        iterator( const iterator& itr ) : _value_Itr( itr._value_Itr ) { }
        ~iterator() { }
        inline iterator& operator=( const iterator& itr ) { _value_Itr = itr._value_Itr; return *this; }
        inline bool operator==( const iterator& itr ) { return _value_Itr == itr._value_Itr; }
        inline bool operator!=( const iterator& itr ) { return _value_Itr != itr._value_Itr; }
        inline V& operator*() const { return *this->_value_Itr; } // dereference operator
        inline V& operator->() const { return *this->_pair_Itr; } // member access operator
        inline iterator& operator++() { ++_value_Itr; return *this; } // post-increment
        inline iterator& operator++(int) { ++_value_Itr; return *this; } // pre-increment
        inline iterator& operator--() { --_value_Itr; return *this; } // post-decrement
        inline iterator& operator--(int) { --_value_Itr; return *this; } // pre-decrement
        
    // Private Functions
    private:
        iterator( const typename std_list::iterator& value_Itr ) : _value_Itr( value_Itr ) { }
    };
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 ListCollection<T>::ListCollection()
                   : std_list()
 {
    
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 ListCollection<T>::ListCollection( const ListCollection<T>& list_collection )
                   : std_list( list_collection )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 ListCollection<T>::~ListCollection()
 {
    
 }
 
 /**
  * operator=() copies the content of the specified ListCollection to this ListCollection.
  *
  * @param (const ListCollection<T>&) list_collection
  * @return ListCollection<T>&
  */
 template <typename T>
 inline ListCollection<T>& ListCollection<T>::operator=( const ListCollection<T>& list_collection )
 {
    std_list::operator=( list_collection );
    
    return *this;
 }
 
 /**
  * add() adds the specified value to this collection.
  *
  * @param (const T&) value
  */
 template <typename T>
 inline void ListCollection<T>::add( const T& value )
 {
    std_list::push_back( value );
 }
 
 /**
  * begin() returns the beginning iterator of this collection.
  *
  * @return ListCollection<T>::iterator
  */
 template <typename T>
 inline typename ListCollection<T>::iterator ListCollection<T>::begin()
 {
    return std_list::begin();
 }
 
 /**
  * end() returns the ending iterator of this collection.
  *
  * @return ListCollection<T>::iterator
  */
 template <typename T>
 inline typename ListCollection<T>::iterator ListCollection<T>::end()
 {
    return std_list::end();
 }
 
 /**
  * clear() removes all values from this collection.
  */
 template <typename T>
 inline void ListCollection<T>::clear()
 {
    std_list::clear();
 }
 
 /**
  * get_front() returns the first value in this collection.
  *
  * @return T
  */
 template <typename T>
 inline T ListCollection<T>::get_front() const
 {
    return std_list::front();
 }
 
 /**
  * remove_front() removes the first value from this collection.
  */
 template <typename T>
 inline void ListCollection<T>::remove_front()
 {
    std_list::pop_front();
 }
 
 /**
  * size() returns the number of values in this collection.
  *
  * @return size_t
  */
 template <typename T>
 inline size_t ListCollection<T>::size() const
 {
    return std_list::size();
 }
 
 /** PUBLIC STATIC FUNCTIONS **/
 
 #endif // LIST_COLLECTION_H